function [nlist] = remove_neighbors(vertex,nlist,nhood)
%This little function is used to remove all the points in a neighborhood
%around a central vertex
%Synatax:   [nlist] = remove_neighbors(vertex,nlist,nhood);
%Input:     vertex = the point as defined by x,y,z around which the search
%                   is conducted
%           nlist = a x by 3 list of points that represent all the points
%                   around the vertex.
%           nhood = defines a cube 2xnhood around the vertex by whihc all
%                   the points in nlist will be filtered.
%
%Output:    nlist = nlist with all the vertices removed around vertex.

%parse data & error check
if nargin<3     %nhood = default
    nhood = 0;
end

%step through the vertex list, remember the vertex list must be rows of [x
%y z], or x by 3 arrays.
for i = 1:size(vertex,1)
    %find the neighbors first
    short_list = find_neighbors(vertex(i,:),nlist,nhood);
    
    %now expunge them.
    for j = 1:size(short_list,1)
        [x,y] = find(nlist(:,1)==short_list(j,1) & nlist(:,2)==short_list(j,2) & nlist(:,3)==short_list(j,3));  %find the point
        nlist(x,:) = [];        %delete the row
    end
end